/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package teamdev.jxcapture.samples.demo;

import teamdev.jxdesktop.PlatformContext;
import teamdev.jxdesktop.win32.ui.Wnd;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Timer;
import java.util.TimerTask;

/**
 * @author Ikryanov Vladimir
 */
public class TimerDialog {

    private final Rectangle rectangle = new Rectangle(74, 46, 69, 23);
    private final Dimension dialogSize = new Dimension(150, 75);
    private final ImageIcon mouseEnterImage = new ImageIcon(TimerDialog.class.getResource("resources/images/mouseEnter.png"));
    private final ImageIcon mouseLeaveImage = new ImageIcon(TimerDialog.class.getResource("resources/images/mouseLeave.png"));
    private final ImageIcon mousePressImage = new ImageIcon(TimerDialog.class.getResource("resources/images/mousePress.png"));

    private ImageIcon currentImage = mouseLeaveImage;

    private JWindow dialog;
    private TimerListener timerListener;
    private Timer dialogTimer = new Timer();
    private int delayTime;
    private boolean mousePressed;

    public TimerDialog(int delayTime) {
        this.delayTime = delayTime;

        dialog = new JWindow();
        dialog.setContentPane(createContentPane());
        dialog.setSize(dialogSize);
        dialog.setLocation(getLocation());
    }

    private JComponent createContentPane() {
        final JPanel contentPane = new TimerPane();
        contentPane.addMouseMotionListener(new MouseMotionAdapter() {
            public void mouseMoved(MouseEvent e) {
                updateDialog(e.getPoint());
            }

            public void mouseDragged(MouseEvent e) {
                updateDialog(e.getPoint());
            }

            private void updateDialog(Point point) {
                if (rectangle.contains(point)) {
                    currentImage = mousePressed ? mousePressImage : mouseEnterImage;
                    contentPane.repaint();
                } else {
                    currentImage = mouseLeaveImage;
                    contentPane.repaint();
                }
            }
        });
        contentPane.addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                if (rectangle.contains(e.getPoint())) {
                    mousePressed = true;
                    currentImage = mousePressImage;
                    contentPane.repaint();
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (rectangle.contains(e.getPoint()) && mousePressed) {
                    currentImage = mouseEnterImage;
                    contentPane.repaint();
                    complete(true);
                }
                mousePressed = false;
            }
        });
        return contentPane;
    }

    private Point getLocation() {
        Rectangle screenRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        return new Point(screenRect.width - dialogSize.width, screenRect.height - dialogSize.height);
    }

    private void complete(boolean isCanceled) {
        dialogTimer.cancel();

        dialog.setVisible(false);
        dialog.dispose();

        if (timerListener != null) {
            timerListener.complete(isCanceled);
        }
    }

    private class TimerPane extends JPanel {
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D) g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(currentImage.getImage(), 0, 0, null);
            g2.setFont(new Font("Verdana", 0, 45));
            g2.setColor(Color.WHITE);
            g2.drawString(String.valueOf(delayTime), 15, 55);
        }
    }

    public interface TimerListener {
        public void complete(boolean isCanceled);
    }

    public void show(TimerListener listener) {
        if (dialog.isVisible()) return;

        timerListener = listener;
        dialog.setVisible(true);

        if (PlatformContext.isWindows()) {
            Wnd window = new Wnd(dialog);
            window.setTopmost(true);
        }

        dialogTimer.schedule(new TimerTask() {
            public void run() {
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        delayTime--;
                        dialog.repaint();
                        if (delayTime == 0) {
                            complete(false);
                        }
                    }
                });
            }
        }, 0, 1000);
    }
}
